# -*- coding: utf-8 -*-
"""
Created on Sun May  9 23:09:36 2021

@author: Fabien
"""

import pandas as pd
from sklearn import linear_model
from sklearn import metrics
import numpy as np
import matplotlib.pyplot as plt
plt.ion()

from matplotlib.colors import ListedColormap

dataset = pd.read_csv(r"\\serveur01\HOSPITF\Travail\Téléchargements\CORRECTIONS/datas/Reseaux_sociaux_auto.csv")
Xt = dataset[["Salaire", "Age"]].to_numpy(dtype=float)
yt = dataset[["Achat"]].to_numpy()

Xt[:,0]=Xt[:,0]/1000. #passage en kilo-euros
# TRACE DU DATASET
plt.close('all')
fig, ax = plt.subplots()
scatter = ax.scatter(Xt[:,0], Xt[:,1], c=yt, cmap = ListedColormap(['r','b']))
legend1 = ax.legend(*scatter.legend_elements(), loc="best", title="Classes")
ax.add_artist(legend1)
plt.xlabel("Salaire"); plt.ylabel("Age")

mu = np.zeros(Xt.shape[1]) ; sigma = np.zeros(Xt.shape[1])
for k in range(Xt.shape[1]):
    mu[k] = np.mean(Xt[:,k]) ; sigma[k] = np.std(Xt[:,k])
    Xt[:,k] = (Xt[:,k]-mu[k])/sigma[k]


def Sigmoide(z):
     return 1 / (1 + np.exp(-z))

def h(X,W):
    return Sigmoide(X.dot(W))

def J(X,Y,W):
    N=np.shape(X)[0]
    S=h(X,W)
    cout = sum(Y*(np.log(S)) + (1-Y)*(np.log(1-S)))
    return (-1/N)*cout[0]

def Gradient(X,Y,W):
    N = np.shape(X)[0]
    return 1/N * X.T.dot(h(X,W)-Y)

def Regression_Logistique(X,Y,nbre_iter=1000,alpha0=float(0.5),d=0,ecart_erreur=1e-8):
    N,D = np.shape(X)
    X = np.concatenate((np.ones((N,1)),X),axis=1)
    W = np.zeros((D+1,1)) # D+1 pour le biais
    Histoire_cout = [J(X,Y,W)]
    c = np.inf; k=0
    while k<nbre_iter and abs(c-Histoire_cout[-1])>ecart_erreur:
        alpha = alpha0*(1/(1+d*k))
        W = W - alpha*Gradient(X,Y,W)
        c = Histoire_cout[-1]
        Histoire_cout.append(J(X,Y,W))
        k+=1
    return W,Histoire_cout

W,L_cout = Regression_Logistique(Xt,yt)
plt.figure()
plt.plot(L_cout)

def prediction(X, W):
    X = np.hstack((np.ones((X.shape[0],1)),X))
    return h(X,W)>=0.5

### TRACES GRAPHIQUES ###

resolution = 500
fig, ax = plt.subplots(figsize=(9, 6))
ax.scatter(Xt[:,0]*sigma[0]+mu[0], Xt[:,1]*sigma[1]+mu[1], c=yt, cmap = ListedColormap(('r','b')))

#limites du graphique
x0lim = (min(Xt[:,0])-0.5,max(Xt[:,0])+0.5)
x1lim = (min(Xt[:,1])-0.5,max(Xt[:,1])+0.5)

# meshgrid
x0 = np.linspace(x0lim[0], x0lim[1], resolution)
x1 = np.linspace(x1lim[0], x1lim[1], resolution)
X0, X1 = np.meshgrid(x0, x1)

# assembler les 2 variables
XX = np.vstack((X0.ravel(), X1.ravel())).T

# Prédictions
Z = prediction(XX, W)
Z = Z.reshape((resolution, resolution))

#Variables introduites initialement (non normalisées)
X0 = X0*sigma[0]+mu[0]
X1 = X1*sigma[1]+mu[1]

ax.pcolormesh(X0, X1, Z, alpha=0.2) #alpha : transparence...
ax.contour(X0, X1, Z, colors='k') # Frontière

# Matrice de confusion
M = np.zeros((len(np.unique(yt)),len(np.unique(yt))))
ym = prediction(Xt,W)

for k in range(len(yt)):
    M[int(yt[k])][int(ym[k])]+=1

print("Matrice de confusion :")
print(M)